PROGRAM VIO2EDIT;       { V.C. II Player Database Editor Source Code file }
    { Started creation using JackEdit source code 07/19/2005. }
    { ======================================================= }

USES CRT, GoldWin, GoldFast, GoldRead, GoldMisc, ChasWare;

     {$I VioVars.inc}   {06/04/08: Removed LordLock}

     {January 2011 Non-Beta development }
{ =================================================================================== }

CONST Version = 'v1.10';
             {10/28/09: v1.10 non-beta used}

      Compile_Date: STRING = 'December 27, 2010.';

         {01/20/10: All code in program is fully tested.}

      Release_Date: STRING = 'December 27th, 2010.';
        {Added 12/30/09}
      { ------------------------------------------------ }

      CfgName  = 'VIO2EDIT.CFG';

      VioPlayer_FN = 'VIO2PLAY.DAT';

      RealName = '1';     LordName  = '2';    PlayNum = '3';
      Visits   = '4';     HitPoints = '5';    HitMax  = '6';
      Strength = '7';     Defense   = '8';    Charm   = '9';
      Forest   = '0';     Gems      = 'A';    Lays    = 'B';

      Cook_Fights   = 'C';    Uncle_Fights = 'D';
      NPC_Fights    = 'E';    Wisdom        = 'F';
      Armour_Rename = 'G';    Cook_Mercy    = 'H';
      FairyRescue   = 'I';    Had_Lemonade  = 'J';
      Killed_Cook   = 'K';    Killed_Uncle = 'L';
      Kissed_Rosie  = 'M';    Used_Gossip   = 'N';
      Weapon_Rename = 'O';
      { ---------------------------------------------- }

      Max_Wisdom: LONGINT = 100000000;  {08/19/05: IGM uses 100 Million exp/day limit.}

      TwoBillion: LongInt = 2000000000;  {06/04/08}

      Max_Visits: BYTE = 20;  {Added 08/02/08}
      { ===================================================== }

      { Q - Quit/Save Changes.   S - Search for Player }
      { X - Delete Player                              }
{ =========================================================== }

{ Rewrote VARs section 06/04/08: }

VAR TSearch: COTTAGE_PLAYER;   { for player searches }

    TVCEdit: COTTAGE_PLAYER;

    Editor_Path: STRING;      { File Vars for VIO2PLAY.DAT access }

    Editor_File:  FILE OF COTTAGE_PLAYER;

    IGMDir: STRING;

    RecordNum   : BYTE;

    Debug_Mode: BOOLEAN;
          {01/18/10: Renamed DebugVar to Debug_Mode.}

      { TempNum, Used, Found: Accessed from VIOVARS.   Used }
      { in record Seek process.  }

    {  Cottage_FN: accessed from VIOVARS.INC file. }
    { ================================================================================== }

   { Replaced with new code from OUTSEDIT 06/04/08: }
PROCEDURE READ_CONFIG;      {Created/verified 11/29/07}
  VAR Config_File: TEXT;

  PROCEDURE MakeConfig;          {verified 11/29/07}
    VAR IGMLoc: STRING;
  BEGIN
    IGMLoc:= PromptStr(0,0,60,'Enter path to Violet''s Cottage II IGM',' Installation ','',FALSE);
    IGMLoc:= S2U(IGMLoc);

    Addtext(AddBack(IGMLoc),CfgName,TRUE);
  END;   { ------------------------------------------------------------- }

BEGIN
  IF NOT Exist(CfgName) THEN MakeConfig;      {verified 11/29/07}

  ASSIGN(Config_File,CfgName);
  RESET(Config_File);
  Readln(Config_File,IGMDir);
  CLOSE(Config_File);

  IGMDir:= S2U(IGMDir);

  { VIO2EDIT: When run from compiler, verified that value of IGMDir is known at this point. }
END;       { Read_Config ------------------------------------------------- }


   { Replaced with new code from OUTSEDIT 06/04/08: }
PROCEDURE READ_VISITORS_FILE;    { Reads the IGM's VIO2PLAY.DAT file. }
BEGIN
  Editor_Path:= S2U(IGMDIR+VioPlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  READ(Editor_File,TVCEdit);

  CLOSE(Editor_File);
END;     { ---------------------------------------------------- }


   { Replaced with new code from OUTSEDIT 06/04/08: }
PROCEDURE WRITE_VISITORS_FILE;      { Writes IGM's VIO2PLAY.DAT file }
BEGIN
  Editor_Path:= S2U(IGMDIR+VioPlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,RecordNum);
  WRITE(Editor_File,TVCEdit);

  CLOSE(Editor_File);
END;     { WRITE_VISITORS_FILE   ------------------------------ }


   { Replaced with new code from OUTSEDIT 06/04/08: }
PROCEDURE SEARCH_PLAYER(Num:INTEGER);
      { Reads VIO2PLAY.DAT. Does search on player record number }
BEGIN
  Editor_Path:= S2U(IGMDIR+VioPlayer_FN);

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  SEEK(Editor_File,Num);
  READ(Editor_File,TSearch);

  CLOSE(Editor_File);
END;     { SEARCH_PLAYER  --------------------------------------------- }


    { Moved here from VIO2UNIT.PAS unit file on 08/23/05 }
FUNCTION Get(b:CHAR):STRING;          {Fully verified 07/19/05}
BEGIN
  CASE UpCase(b) OF
     RealName : Get:='`!'+TVCEdit.RealName;

     LordName : Get:='`$'+TVCEdit.LordName;        {moved entry up to here 07/11/05}

     PlayNum  : Get:='`@'+N2S(TVCEdit.PlayNum);  {Contains player's LORD player #.}

     Visits   : IF TVCEdit.Visits = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TVCEdit.Visits);

     HitPoints: IF TVCEdit.HitPoints = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TVCEdit.HitPoints);

     HitMax   : IF TVCEdit.HitMax = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TVCEdit.HitMax);

     Strength : IF TVCEdit.Strength = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TVCEdit.Strength);

     Defense  : IF TVCEdit.Defense = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TVCEdit.Defense);

     Charm    : IF TVCEdit.Charm = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TVCEdit.Charm);

     Forest   : IF TVCEdit.Forest = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TVCEdit.Forest);

     Gems     : IF TVCEdit.Gems = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+COMMA(TVCEdit.Gems);

     Lays     : IF TVCEdit.Lays = 0
                  THEN  Get:= '`#None'
                  ELSE  Get:= '`$'+N2S(TVCEdit.Lays);

     Cook_Fights : IF TVCEdit.Cook_Fights = 0
                     THEN  Get:= '`#None'
                     ELSE  Get:= '`$'+N2S(TVCEdit.Cook_Fights);

     Uncle_Fights : IF TVCEdit.Uncle_Fights = 0
                       THEN  Get:= '`#None'
                       ELSE  Get:= '`$'+N2S(TVCEdit.Uncle_Fights);

     NPC_Fights: IF TVCEdit.NPC_Fights = 0
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+N2S(TVCEdit.NPC_Fights);

     Wisdom    : IF TVCEdit.Wisdom = 0
                   THEN  Get:= '`#None'
                   ELSE  Get:= '`$'+COMMA(TVCEdit.Wisdom);

     Armour_Rename: IF TVCEdit.Armour_Rename
                      THEN Get:= '`0Yes! '   ELSE Get:= '`%Nope!';

     Cook_Mercy  : IF TVCEdit.Cook_Mercy
                     THEN  Get:= '`0Yes!'   ELSE  Get:= '`%Nope!';

     FairyRescue : IF TVCEdit.Fairy_Rescue
                     THEN  Get:= '`0Yes!'   ELSE Get:= '`%Nope!';

     Had_Lemonade: IF TVCEdit.Had_Lemonade
                     THEN Get:= '`0Yes! '   ELSE Get:= '`%Nope!';

     Had_Lemonade : IF TVCEdit.Had_Lemonade
                      THEN  Get:= '`0Yes!'   ELSE Get:= '`%Nope!';

     Killed_Cook  : IF TVCEdit.Killed_Cook
                      THEN  Get:= '`0Yes!'   ELSE Get:= '`%Nope!';

     Killed_Uncle: IF TVCEdit.Killed_Uncle
                      THEN Get:= '`0Yes! '   ELSE Get:= '`%Nope!';

     Kissed_Rosie : IF TVCEdit.Kissed_Rosie
                      THEN  Get:= '`0Yes!'   ELSE Get:= '`%Nope!';

     Used_Gossip  : IF TVCEdit.Used_Gossip
                      THEN  Get:= '`0Yes!'   ELSE Get:= '`%Nope!';

     Weapon_Rename: IF TVCEdit.Weapon_Rename
                      THEN Get:= '`0Yes! '   ELSE Get:= '`%Nope!';
  END;

  { Updated with new code from OUTSEDIT 06/04/08: }

  CursorOff;   {10/15/07.  needed to fix bug found by Dennis Collins}
               { in 2006 when he checked on KLBEDIT. }

    { When program's user would change a setting in a dialog box, when }
    { they returned to the main screen, the cursor would be back on the }
    { screen, so this keeps the cursor deactivated while the editor runs. }
END;     { GET Func. ----------------------------------------------------- }


   { 06/04/08: Renamed DoRealName to DO_REAL_NAME. }

{ 1 }PROCEDURE DO_REAL_NAME;     {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.RealName:=
  PromptStr(0,0,50,'Enter REAL name for player',' Player Real Name Change ',TVCEdit.RealName,FALSE);

  WRITE_VISITORS_FILE;
  CWriteXy(22,4,Replicate(50,' '));  { Write data on position 25, Line #4. }
  CWriteXy(22,4,Get(RealName));
END;


   { 06/04/08: Renamed DoLordName to DO_Lord_NAME. }

{ 2 }PROCEDURE DO_Lord_NAME;     {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.LordName:=
  PromptStr(0,0,20,'Enter LORD Name for player',' Player Lord Name Change ',TVCEdit.LordName,FALSE);

  WRITE_VISITORS_FILE;
  CwriteXY(22,5,Replicate(20,' '));
  CwriteXY(22,5,Get(LordName));
END;


   { 06/04/08: Replaced DO_PlayNum with DO_PLAYER_NUMBER. }

  { ##### OUTSEDIT Coding done 11/29/07.  ##### }
  { Adapted for usage by VIO2EDIT.EXE on 06/04/08 }
  { In normal usage, don't allow users to change LORD Player Numbers. }

{ 3 }PROCEDURE DO_PLAYER_NUMBER;              {06/04/08: VERIFIED 06/04/08}
BEGIN
  TVCEdit.PlayNum:=
  PromptNum(0,0,'Enter player''s LORD Player # (0-160)?',' LORD Player Number Change ',TVCEdit.PlayNum,0,160,TRUE);

  WRITE_VISITORS_FILE;
  CWriteXy(58,5,Replicate(5,' '));    { Allow room for 3 digits, and 2 blank spaces. 07/13/05}
  CWriteXy(58,5,Get(PlayNum));
END;


{ 4 }PROCEDURE DO_VISITS;               {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.Visits:=
    PromptNum(0,0,'Enter Visits Today (0-20)?',' Visits Today Change',TVCEdit.Visits,0,Max_Visits,TRUE);
                {08/02/08: edited to use Max_Visits const.}

  WRITE_VISITORS_FILE;
  CwriteXY(22,6,Replicate(5,' '));     {Revised 07/27/08}
  CwriteXY(22,6,Get(Visits));
END;   {IGM's Max Visits/Day Limit is 20, as of mid-July.}


{ 5 }PROCEDURE DO_HITPOINTS;               {06/04/08: verified 07/06/08}
BEGIN                   {Edited 01/10/09: changes verified 5:26 pm 01/10/09}
  TVCEdit.HitPoints:=
    PromptNum(0,0,'Enter HitPoints (-16,000-16,000)?',' HitPoints Change',TVCEdit.HitPoints,-16000,16000,TRUE);
         {01/10/09: edited code to use max of 16,000 instead of 8,000}

  WRITE_VISITORS_FILE;
  CwriteXY(57,6,Replicate(11,' '));   {Changed Replicate(6) to use 11. 01/10/09}
  CwriteXY(57,6,Get(HitPoints));
END;


   { 06/04/08: Renamed DO_HitMax to DO_MAX_HITPOINTS. }

{ 6 }PROCEDURE DO_MAX_HITPOINTS;                 {06/04/08: verified 07/06/08}
BEGIN                                  {rewrote 08/11/08}
  TVCEdit.HitMax:=
  PromptNum(0,0,'Enter Max Hit-Points (-8,000 to 8,000)?',' Max Hit-Points Change ',TVCEdit.HitMax,-8000,8000,TRUE);

  WRITE_VISITORS_FILE;
  CWriteXY(22,7,Replicate(6,' '));
  CWriteXY(22,7,Get(HitMax));
END;


{ 7 }PROCEDURE DO_Strength;                 {06/04/08: verified 07/06/08}
BEGIN                           {rewrote 08/11/08}
  TVCEdit.Strength:=
  PromptNum(0,0,'Enter Strength Points (-8,000 to 8,000)?',' Strength Points Change ',TVCEdit.Strength,-8000,8000,TRUE);

  WRITE_VISITORS_FILE;
  CWriteXY(57,7,Replicate(6,' '));
  CWriteXY(57,7,Get(Strength));
END;


{ 8 }PROCEDURE DO_Defense;                 {06/04/08: verified 07/06/08}
BEGIN                         {rewrote 08/11/08}
  TVCEdit.Defense:=
  PromptNum(0,0,'Enter Defense Points (-8,000 to 8,000)?',' Defense Points Change ',TVCEdit.Defense,-8000,8000,TRUE);

  WRITE_VISITORS_FILE;
  CWriteXY(22,8,Replicate(6,' '));
  CWriteXY(22,8,Get(Defense));
END;


{ 9 }PROCEDURE DO_Charm;               {06/04/08: verified 07/06/08}
BEGIN                           {rewrote 08/11/08}
  TVCEdit.Charm:=
  PromptNum(0,0,'Enter Charm Points (-8,000 to 8,000)?',' Charm Points Change ',TVCEdit.Charm,-8000,8000,TRUE);

  WRITE_VISITORS_FILE;
  CwriteXY(57,8,Replicate(9,' '));  {12/26/08: changed 6 to 9. error fix}
  CwriteXY(57,8,Get(Charm));
END;


{ 0 }PROCEDURE DO_Forest;                 {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.Forest:=
  PromptNum(0,0,'Enter Forest Fights (0-8,000)?',' Forest Fights Change ',TVCEdit.Forest,0,8000,TRUE);

  WRITE_VISITORS_FILE;
  CWriteXY(22,9,Replicate(6,' '));
  CWriteXY(22,9,Get(Forest));
END;


{ A }PROCEDURE DO_Gems;    {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.Gems:=
    PromptNum(0,0,'Enter Gems (0-8,000)?',' Gems Change ',TVCEdit.Gems,0,8000,TRUE);

  WRITE_VISITORS_FILE;
  CWriteXY(57,9,Replicate(6,' '));
  CWriteXY(57,9,Get(Gems));
END;


{ B }PROCEDURE DO_Lays;      {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.Lays:=
  PromptNum(0,0,'Enter # of Lays (0-10)?',' Lays Change',TVCEdit.Lays,0,10,TRUE);

  WRITE_VISITORS_FILE;
  CwriteXY(22,10,Replicate(4,' '));
  CwriteXY(22,10,Get(Lays));
END;


{ C }PROCEDURE DO_Cook_Fights;               {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.Cook_Fights:=
  PromptNum(0,0,'Enter Cook Fights (0-2)?',' Cook Fights Change', TVCEdit.Cook_Fights,0,2,TRUE);

  WRITE_VISITORS_FILE;
  CwriteXY(57,10,Replicate(4,' '));
  CwriteXY(57,10,Get(Cook_Fights));
END;


{ D }PROCEDURE DO_Uncle_Fights;               {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.Uncle_Fights:=              {Revised 07/27/08}
  PromptNum(0,0,'Enter Uncle Fights (0-2)?',' Uncle Fights Change', TVCEdit.Uncle_Fights,0,2,TRUE);

  WRITE_VISITORS_FILE;
  CwriteXY(22,11,Replicate(4,' '));
  CwriteXY(22,11,Get(Uncle_Fights));
END;


{ E }PROCEDURE DO_NPC_Fights;      {Revised 10/12/05}  {06/04/08: verified 07/06/08}
BEGIN
  TVCEdit.NPC_Fights:=
  PromptNum(0,0,'Enter NPC Fights (0-4)?',' Total NPC Fights Change', TVCEdit.NPC_Fights,0,4,TRUE);

  WRITE_VISITORS_FILE;
  CwriteXY(57,11,Replicate(4,' '));
  CwriteXY(57,11,Get(NPC_Fights));
END;


{ F }PROCEDURE DO_Wisdom;               {Revised 08/19/05: verified 07/06/08}
BEGIN
  TVCEdit.Wisdom:=
  PromptNum(0,0,'Enter Wisdom Points (0-100 Million)?',' Wisdom Points Change', TVCEdit.Wisdom,0,Max_Wisdom,TRUE);

  WRITE_VISITORS_FILE;
  CwriteXY(22,12,Replicate(13,' '));
  CwriteXY(22,12,Get(Wisdom));
END;


{ G }PROCEDURE DO_Armour_Rename;                 {06/04/08: verified 07/06/08}
BEGIN
  IF TVCEdit.Armour_Rename THEN TVCEdit.Armour_Rename:= FALSE
    ELSE IF NOT TVCEdit.Armour_Rename THEN TVCEdit.Armour_Rename:= TRUE;

  WRITE_VISITORS_FILE;
  CWriteXY(58,12,Replicate(6,' '));
  CWriteXY(58,12,Get(Armour_Rename));
END;


{ H }PROCEDURE DO_Cook_Mercy;                 {06/04/08: verified 07/06/08}
BEGIN
  IF TVCEdit.Cook_Mercy THEN TVCEdit.Cook_Mercy:= FALSE
    ELSE IF NOT TVCEdit.Cook_Mercy THEN TVCEdit.Cook_Mercy:= TRUE;

  WRITE_VISITORS_FILE;
  CWriteXY(22,13,Replicate(6,' '));
  CWriteXY(22,13,Get(Cook_Mercy));
END;


    { 06/04/08: Renamed DO_FairyRescue to DO_FAIRY_RESCUE. }

{ I }PROCEDURE DO_FAIRY_RESCUE;                 {06/04/08: verified 07/06/08}
BEGIN                       {revised 08/11/08}
  IF TVCEdit.Fairy_Rescue THEN TVCEdit.Fairy_Rescue:= FALSE
    ELSE IF NOT TVCEdit.Fairy_Rescue THEN TVCEdit.Fairy_Rescue:= TRUE;

  WRITE_VISITORS_FILE;
  CWriteXY(58,13,Replicate(6,' '));
  CWriteXY(58,13,Get(FairyRescue));
END;


{ J }PROCEDURE DO_Had_Lemonade;                 {06/04/08: Verified 07/06/08}
BEGIN
  IF TVCEdit.Had_Lemonade THEN TVCEdit.Had_Lemonade:= FALSE
    ELSE IF NOT TVCEdit.Had_Lemonade THEN TVCEdit.Had_Lemonade:= TRUE;

  WRITE_VISITORS_FILE;
  CWriteXY(22,14,Replicate(6,' '));
  CWriteXY(22,14,Get(Had_Lemonade));
END;


{ K }PROCEDURE DO_Killed_Cook;                 {06/04/08: Verified 07/06/08}
BEGIN
  IF TVCEdit.Killed_Cook THEN TVCEdit.Killed_Cook:= FALSE
    ELSE IF NOT TVCEdit.Killed_Cook THEN TVCEdit.Killed_Cook:= TRUE;

  WRITE_VISITORS_FILE;
  CWriteXY(58,14,Replicate(6,' '));
  CWriteXY(58,14,Get(Killed_Cook));
END;


{ L }PROCEDURE DO_Killed_Uncle;                 {06/04/08: Verified 07/06/08}
BEGIN
  IF TVCEdit.Killed_Uncle THEN TVCEdit.Killed_Uncle:= FALSE
    ELSE IF NOT TVCEdit.Killed_Uncle THEN TVCEdit.Killed_Uncle:= TRUE;

  WRITE_VISITORS_FILE;                  {Revised 07/27/08}
  CWriteXY(22,15,Replicate(6,' '));
  CWriteXY(22,15,Get(Killed_Uncle));
END;


{ M }PROCEDURE DO_Kissed_Rosie;                 {06/04/08: Verified 07/06/08}
BEGIN
  IF TVCEdit.Kissed_Rosie THEN TVCEdit.Kissed_Rosie:= FALSE
    ELSE IF NOT TVCEdit.Kissed_Rosie THEN TVCEdit.Kissed_Rosie:= TRUE;

  WRITE_VISITORS_FILE;
  CWriteXY(58,15,Replicate(6,' '));
  CWriteXY(58,15,Get(Kissed_Rosie));
END;


{ N }PROCEDURE DO_Used_Gossip;                 {06/04/08: Verified 07/06/08}
BEGIN
  IF TVCEdit.Used_Gossip THEN TVCEdit.Used_Gossip:= FALSE
    ELSE IF NOT TVCEdit.Used_Gossip THEN TVCEdit.Used_Gossip:= TRUE;

  WRITE_VISITORS_FILE;
  CWriteXY(22,16,Replicate(6,' '));
  CWriteXY(22,16,Get(Used_Gossip));
END;


{ O }PROCEDURE DO_Weapon_Rename;           {06/04/08: Verified 07/06/08}
BEGIN
  IF TVCEdit.Weapon_Rename THEN TVCEdit.Weapon_Rename:= FALSE
    ELSE IF NOT TVCEdit.Weapon_Rename THEN TVCEdit.Weapon_Rename:= TRUE;

  WRITE_VISITORS_FILE;
  CWriteXY(58,16,Replicate(6,' '));
  CWriteXY(58,16,Get(Weapon_Rename));
END;


{ No point in having Delete Player in this IGM. DeletePlayer process was removed. }

{ note: To use Y, N responses via keyboard, one has to use }
{ the ALT key. Or simply use the mouse to click on the option wanted. }


{ 06/04/08: replaced MaxPlayers using OUTSEDIT code. }

FUNCTION  MaxPlayers: WORD; { Gets the number of customer records }
BEGIN
  MaxPlayers:= 1;

  Editor_Path:= S2U(IGMDIR+VioPlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;

  FileMode:= $12;

  ASSIGN(Editor_File,Editor_Path);
  RESET(Editor_File);

  MaxPlayers:= FileSize(Editor_File);

  CLOSE(Editor_File);
END;     { MaxPlayers  --------------------------------------------- }


    { Replaced with KLBEDIT.PAS file code on 09/12/05 }
FUNCTION GetRecordNum:STRING;     {Revised to include MaxPlayers data. VERIFIED 07/15/05}
BEGIN
  GetRecordNum:='`$'+N2S(RecordNum + 1)+' `%of `@'+N2S(MaxPlayers);
    { 08/30/05: Changed so that first record # displayed will be 1, not 0.}

  { No changes needed 06/04/08. }
END;     { GetRecordNum ---------------------------------------------- }


    { Moved here from VIO2UNIT.PAS unit file on 08/23/05 }
    {01/18/10: renamed ShowMenu to SHOW_MENU.}
PROCEDURE SHOW_MENU;
BEGIN
  ClrScr;

  CWriteln('`%    ** `@Violet''s Cottage II `!Player Database Editor `$'+Version+' `%**');  {Line 1}
  CWriteln('`#    VIO2PLAY.DAT `0Record Number: `@'+GetRecordNum);              {Line 2}
  CWriteLn(' ');

  { CwGotoXY, CWriteXY notes: X is position #, Y is line #. }

  CWGotoXY(3,4);   { Line 4 }
  CWriteLN('`#(`%1`#) `!Real Name    `%: '+Get(RealName));

  { -------------------------------------------- }
  CWGotoXY(3,5);                {Line 5}
    CWrite('`#(`%2`#) `!LORD Name    `%: '+Get(LordName));

  CWGotoXY(45,5);
  CWriteLN('`#(`%3`#) `!Player #`%: '+Get(PlayNum));
  { -------------------------------------------- }

  CWGotoXY(3,6);                 {Line 6}
    CWrite('`#(`%4`#) `!Visits Today `%: '+Get(Visits));

  CWGotoXY(38,6);
  CWriteLN('`#(`%5`#) `!Hit-Points   `%: '+Get(HitPoints));
  { -------------------------------------------- }

  CWGotoXY(3,7);                {Line 7}
    CWrite('`#(`%6`#) `!Max HitPoints`%: '+Get(HitMax));

  CWGotoXY(38,7);
  CWriteLN('`#(`%7`#) `!Strength     `%: '+Get(Strength));
  { -------------------------------------------- }

  CWGotoXY(3,8);                 {Line 8}
    CWrite('`#(`%8`#) `!Defense      `%: '+Get(Defense));

  CWGotoXY(38,8);
  CWriteLN('`#(`%9`#) `!Charm Points `%: '+Get(Charm));
  { -------------------------------------------- }

  CWGotoXY(3,9);                 {Line 9}
    CWrite('`#(`%0`#) `!Forest Pts   `%: '+Get(Forest));

  CWGotoXY(38,9);
  CWriteLN('`#(`%A`#) `!Gems Gain    `%: '+Get(Gems));
  { -------------------------------------------- }

  CWGotoXY(3,10);                 {Line 10}
    CWrite('`#(`%B`#) `!Lays         `%: '+Get(Lays));

  CWGotoXY(38,10);
  CWriteLN('`#(`%C`#) `!Cook Fights  `%: '+Get(Cook_Fights));
  { -------------------------------------------- }

  CWGotoXY(3,11);       {Line 11}      {revised 08/11/08}
    CWrite('`#(`%D`#) `!Uncle Fights `%: '+Get(Uncle_Fights));

  CWGotoXY(38,11);
  CWriteLN('`#(`%E`#) `!NPC Fights   `%: '+Get(NPC_Fights));
  { -------------------------------------------- }

  CWGotoXY(3,12);                 {Line 12}
    CWrite('`#(`%F`#) `!Wisdom Points`%: '+Get(Wisdom));

  CWGotoXY(38,12);
  CWriteLN('`#(`%G`#) `!Armor Rename? `%: '+Get(Armour_Rename));
  { -------------------------------------------- }

  CWGotoXY(3,13);                 {Line 13}
    CWrite('`#(`%H`#) `!Cook Mercy?  `%: '+Get(Cook_Mercy));

  CWGotoXY(38,13);
  CWriteLN('`#(`%I`#) `!Fairy Rescue? `%: '+Get(FairyRescue));
  { -------------------------------------------- }

  CWGotoXY(3,14);
    CWrite('`#(`%J`#) `!Had Lemonade?`%: '+Get(Had_Lemonade));

  CWGotoXY(38,14);
  CWriteLN('`#(`%K`#) `!Killed Cook?  `%: '+Get(Killed_Cook));
  { -------------------------------------------- }

  CWGotoXY(3,15);                         {revised 08/11/08}
    CWrite('`#(`%L`#) `!Killed Uncle `%: '+Get(Killed_Uncle));

  CWGotoXY(38,15);
  CWriteLN('`#(`%M`#) `!Kissed Rosie? `%: '+Get(Kissed_Rosie));
  { -------------------------------------------- }

  CWGotoXY(3,16);
    CWrite('`#(`%N`#) `!Used Gossip? `%: '+Get(Used_Gossip));

  CWGotoXY(38,16);
  CWriteLN('`#(`%O`#) `!Weapon Rename?`%: '+Get(Weapon_Rename));
  { -------------------------------------------- }

  CWriteLn(' ');  {Blank Line, Line #17.}

  CWGotoXY(3,18);
    CWrite('`2(`0S`2) `%Search for Player');
       {01/20/10: Changed "Search by Name" to "Search for Player".}

    {01/20/10: Changed to use S instead of X for Search Player option}

  CWGotoXY(40,18);
  CWriteln('`2(`0]`2) `%Advance One Record');
  { -------------------------------------------- }

  CWGotoXY(3,19);
    CWrite('`2(`0[`2) `%Back Up One Record');

  CWGotoXY(40,19);
  CWriteln('`2(`0*`2) `%New Day for Player');
  { -------------------------------------------- }

  CWGotoXY(3,20);      {Added 01/18/10}
  CWriteLn('`2(`0X`2) `%Delete Current Player');   {Added 01/18/10}
         {01/20/10: Changed "Delete Player Record" to "Delete Current Player".}

  CWGotoXY(3,21);      {Added 01/18/10}
  CWriteln(' ');  {Blank Line, Line #21.}  {edited 01/18/10}

  CWGotoXY(3,22);   {Edited 01/18/10}
  Cwrite('`$    Input key to change, or `%Q `$to Quit and Save.');

  IF Debug_Mode THEN    {Added 01/18/10: VERIFIED 01/20/10 3:05 am}
    CWrite('  `@[Debug Mode] ');

END;     { SHOW_MENU  ------------------------------------------------------ }


{ 06/04/08: replaced DoPlayerSearch with DO_PLAYER_SEARCH  }
{ using modified OUTSEDIT code. Vio2edit uses S code now.  }
                                      
{ S }PROCEDURE DO_PLAYER_SEARCH;       {VERIFIED}
VAR Counter, YN : BYTE;
    Temp, OTemp : STRING;

BEGIN
  Editor_Path:= S2U(IGMDIR+VioPlayer_FN);

  IF NOT Exist(Editor_Path) THEN Exit;
     { if no VIO2PLAY.DAT then we can't search and }
     {  couldn't have made it here to begin with. }

  Counter:= 0;
  Temp:= PromptStr(0,0,50,' Enter full or partial name: ',' Player Search ','',FALSE);
  OTemp:= Temp;
  Temp:= S2U(Temp);  { upcase the whole string }

  REPEAT
    SEARCH_PLAYER(Counter);

    { This next evaluation is checking to see if TEMP exists anywhere in  }
    {  either field of record.  If YES, then execute the next section,    }
    {  otherwise increment counter and move on.  Note: Using FUNCTION NoColor  }
    {  to strip Lord color codes for string eval and display. }

   IF (POS(Temp,S2U(TSearch.LordName))>0) OR (POS(Temp,NoColor(S2U(TSearch.RealName)))>0) THEN
     BEGIN
       YN:= PromptYesNo('','Are you looking for:|'+TSearch.LordName+' known as '+NoColor(TSearch.RealName)+'?');

       IF YN=1 THEN {1 means YES answer}
         BEGIN
            RecordNum:= Counter; { LORD Player # to display matches the counter }

            READ_VISITORS_FILE;
            SHOW_MENU;
            Exit; { bail out of loop since we got who we want }
          END;
     END;

    Inc(Counter);
  UNTIL Counter=MaxPlayers; { End of repeat loop, repeats until we get
										to last player record. }

  { if we make it to here, then there were no matches. }

  PromptOK(' Search Error! ','No match found for '+OTemp+'!');  {02/11/04}
END;   { DO_PLAYER_SEARCH ====================================== }


{ Added 01/18/10 using modified OT20EDIT.PAS code: }

{ X }PROCEDURE DO_PLAYER_DELETION;   {Created 01/18/10: VERIFIED 01/20/10 3:05 am}
  VAR YN: BYTE;
BEGIN
  { I hate having to bust up lines due to "line too long" error }
  { messages! The next 3 lines are all one line of code. Chas.}

  YN:= PromptYesNo
   (' Warning Will Robinson! Player Deletion! ','Are you sure you want to delete the player :|'+TVCEDIT.LordName+' known'
     +' as '+NoColor(TVCEDIT.RealName)+'?');

  IF YN = 1 THEN {1 means YES answer}
    BEGIN
      TVCEDIT.RealName:= 'X';
      TVCEDIT.LordName:= '* DELETED *';

      TVCEDIT.PlayNum:= 160;

        { Note: PlayNum 160 should not be in use by any valid players.}

      TVCEDIT.Visits:= 0;

      TVCEDIT.HitPoints:= 0;

      TVCEDIT.HitMax:= 0;
      TVCEDIT.Strength:= 0;
      TVCEDIT.Defense:= 0;
      TVCEDIT.Charm:= 0;
      TVCEDIT.Forest:= 0;

      TVCEDIT.Gems:= 0;
      TVCEDIT.Lays:= 0;

      TVCEdit.Cook_Fights:= 0;
      TVCEDIT.Uncle_Fights:= 0;
      TVCEDIT.NPC_Fights:= 0;
      TVCEDIT.Wisdom:= 0;

      TVCEDIT.Armour_Rename:= FALSE;
      TVCEdit.Cook_Mercy:= FALSE;
      TVCEdit.Fairy_Rescue:= FALSE;

      TVCEdit.Had_Lemonade:= FALSE;
      TVCEdit.Killed_Cook:= FALSE;
      TVCEdit.Killed_Uncle:= FALSE;

      TVCEdit.Kissed_Rosie:= FALSE;
      TVCEdit.Used_Gossip:= FALSE;
      TVCEdit.Weapon_Rename:= FALSE;
      { ========================================== }

      WRITE_VISITORS_FILE;

      PromptOK(' Record Deletion: ','Actual record deletion will be handled by the IGM the |'
                 +'next day, when it runs the New Day maintenance process. ');

      SHOW_MENU;
    END;
END;       {  DO_PLAYER_DELETION ==============================  }


{ 06/04/08: Renamed DoNewDay to DO_NEW_DAY. Updated segments. }

{ * }PROCEDURE DO_NEW_DAY;        {06/04/08: verified}
BEGIN
  CWGotoXY(5,24);
  CWriteLn('  `0Running `!"Reset Player''s Stats" `0process. 3-second delay.');

  DELAY(3000);

  { Notes: PlayNum and Visits are BYTE fields. Neither can ever }
  { have negative values.  }

  IF (TVCEdit.PlayNum > 160) THEN    {Enabled 05/26/08: verified 07/06/08}
    BEGIN
      TVCEdit.PlayNum:= 160;
      PromptOK('Advisory:',' Resetting LORD Player # field to 160.');
    END;

  { --------------------------------------------------- }
  IF TVCEdit.Visits > 0 THEN       {Enabled 05/26/08: 07/06/08}
    BEGIN
      TVCEdit.Visits:= 0;
      PromptOK('Advisory:',' Resetting the Visits Today field to Zero.');
    END;

  { 10/03/05: Removed negative values code blocks for PlayNum, Visits. }
  { Neither BYTE variable can be set to a negative amount. }

      { --------------------------------------------------- }
  IF TVCEdit.HitPoints < 0 THEN   {Old code: VERIFIED}
    BEGIN
      TVCEdit.HitPoints:= 0;
      PromptOK('Advisory:',' Reset negative HitPoints field to Zero.');
    END;

  IF TVCEdit.HitPoints > 0 THEN   {Old code: VERIFIED}
    BEGIN
      TVCEdit.HitPoints:= 0;
      PromptOK('Advisory:',' Resetting HitPoints to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.HitMax < 0 THEN      {Old code: VERIFIED}
    BEGIN
      TVCEdit.HitMax:= 0;
      PromptOK('Advisory:',' Reset negative Max HitPoints field to Zero.');
    END;

  IF TVCEdit.HitMax > 0 THEN      {Old code: VERIFIED}
    BEGIN
      TVCEdit.HitMax:= 0;
      PromptOK('Advisory:',' Resetting Max HitPoints to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.Strength < 0 THEN    {Old code: VERIFIED}
    BEGIN
      TVCEdit.Strength:= 0;
      PromptOK('Advisory:',' Reset negative Strength Points field to Zero.');
    END;

  IF TVCEdit.Strength > 0 THEN    {Old code: VERIFIED}
    BEGIN
      TVCEdit.Strength:= 0;
      PromptOK('Advisory:',' Resetting Strength Points to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.Defense < 0 THEN     {Old code: VERIFIED}
    BEGIN
      TVCEdit.Defense:= 0;
      PromptOK('Advisory:',' Reset negative Defense Points field to Zero.');
    END;

  IF TVCEdit.Defense > 0 THEN     {Old code: VERIFIED}
    BEGIN
      TVCEdit.Defense:= 0;
      PromptOK('Advisory:',' Resetting Defense Points to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.Charm < 0 THEN       {Old code: VERIFIED}
    BEGIN
      TVCEdit.Charm:= 0;
      PromptOK('Advisory:',' Reset negative Charm Points field to Zero.');
    END;

  IF TVCEdit.Charm > 0 THEN       {Old code: VERIFIED}
    BEGIN
      TVCEdit.Charm:= 0;
      PromptOK('Advisory:',' Resetting Charm Points to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.Forest < 0 THEN      {Old code: VERIFIED}
    BEGIN
      TVCEdit.Forest:= 0;
      PromptOK('Advisory:',' Reset negative Forest Fights field to Zero.');
    END;

  IF TVCEdit.Forest > 0 THEN      {Old code: VERIFIED}
    BEGIN
      TVCEdit.Forest:= 0;
      PromptOK('Advisory:',' Resetting Forest Fights to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.Gems < 0 THEN        {Old code: VERIFIED}
    BEGIN
      TVCEdit.Gems:= 0;
      PromptOK('Advisory:',' Reset negative Gems field to Zero.');
    END;

  IF TVCEdit.Gems > 0 THEN        {Old code: VERIFIED}
    BEGIN
      TVCEdit.Gems:= 0;
      PromptOK('Advisory:',' Resetting Gems to Zero.');
    END;

  { 10/03/05: Removed negative values code blocks for Lays, Cook_Fights, }
  { Uncle_Fights, and NPC_Fights.  Neither BYTE VAR allows negative amounts. }

      { --------------------------------------------------- }
  IF TVCEdit.Lays > 0 THEN        {Old code: VERIFIED}
    BEGIN
      TVCEdit.Lays:= 0;
      PromptOK('Advisory:',' Resetting Lays to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.Cook_Fights > 0 THEN      {Old code: VERIFIED}
    BEGIN
      TVCEdit.Cook_Fights:= 0;
      PromptOK('Advisory:',' Resetting Cook Fights to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.Uncle_Fights > 0 THEN    {Old code: VERIFIED}
    BEGIN
      TVCEdit.Uncle_Fights:= 0;
      PromptOK('Advisory:',' Resetting Uncle Fights to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.NPC_Fights > 0 THEN       {Old code: VERIFIED}
    BEGIN
      TVCEdit.NPC_Fights:= 0;
      PromptOK('Advisory:',' Resetting NPC Fights to Zero.');
    END;

      { --------------------------------------------------- }
  IF TVCEdit.Wisdom < 0 THEN           {Old code: VERIFIED}
    BEGIN
      TVCEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Reset negative Wisdom Points field to Zero.');
    END;

  IF TVCEdit.Wisdom > 0 THEN           {Old code: VERIFIED}
    BEGIN
      TVCEdit.Wisdom:= 0;
      PromptOK('Advisory:',' Resetting Wisdom Points to Zero.');
    END;

  { -------------------------------------- }
  TVCEdit.Armour_Rename:= FALSE;      {Old code: VERIFIED}

  TVCEdit.Cook_Mercy:= FALSE;         {Old code: VERIFIED}

  TVCEdit.Fairy_Rescue:= FALSE;       {revised 08/11/08}

  TVCEdit.Had_Lemonade:= FALSE;       {Old code: VERIFIED}

  TVCEdit.Killed_Cook:= FALSE;        {Old code: VERIFIED}

  TVCEdit.Killed_Uncle:= FALSE;       {Old code: VERIFIED}

  TVCEdit.Kissed_Rosie:= FALSE;       {Old code: VERIFIED}

  TVCEdit.Used_Gossip:= FALSE;        {Old code: VERIFIED}

  TVCEdit.Weapon_Rename:= FALSE;      {Old code: VERIFIED}

  { --------------------------------------------------- }
  SHOW_MENU;

  WRITE_VISITORS_FILE;
END;     { DoNewDay  =============================================== }


        {Created 06/04/08 to test New Day process code}

{01/18/10: Deleted DO_NEWDAY_TESTING. Not needed currently}

{ 06/04/08: Renamed RunEditor to RUN_EDITOR. }

PROCEDURE RUN_EDITOR;       {06/04/08: Verified 07/06/08}
  VAR Code: CHAR;
BEGIN
  SHOW_MENU;

  REPEAT
    Code:= AInput('1234567890ABCDEFGHIJKLMNOQSX][*');
      {01/18/10: Deleted # code.}  {01/20/10: Error fix. Added S & X codes.}

    CASE Code OF
      '1' : DO_REAL_NAME;

      '2' : DO_LORD_NAME;

      '3' : BEGIN         {Rewrote 01/18/10}
              CWGotoXY(1,21);   {01/18/10: Changed 23 to 21}

              CWriteLn('                                                                      ');  {09/13/08. needed here}
                {Writes blank line to screen. Line #21. 01/18/10}

              CWriteLn('  `0The `$LORD Player Number `0field is display-only.  I don''t see     ');
                   {01/20/10: Added blank spaces to cover up [Debug Mode] on-screen.}

              CWriteLn('  `0a valid reason to allow it to be edited.  3-second delay. ');
              DELAY(3000);

              IF Debug_Mode THEN   {06/04/08: verified 07/06/08}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is ');
                  CWriteLn('  `0allowed to modify the `#Player Number `0field.  Do so with ');
                  CWriteLn('  `@CAUTION `0because it is a `@VERY `0important database field.');
                  DELAY(3000);

                  DO_PLAYER_NUMBER;
                END;

              SHOW_MENU;
            END;

      '4' : DO_VISITS;

      '5' : DO_HITPOINTS;

      '6' : DO_MAX_HITPOINTS;

      '7' : DO_Strength;

      '8' : DO_Defense;

      '9' : DO_Charm;

      '0' : DO_Forest;

      'A' : DO_Gems;

      'B' : DO_Lays;

      'C' : DO_Cook_Fights;

      'D' : DO_Uncle_Fights;

      'E' : DO_NPC_Fights;

      'F' : DO_Wisdom;

      'G' : DO_Armour_Rename;

      'H' : DO_Cook_Mercy;

      'I' : DO_FAIRY_RESCUE;

      'J' : DO_Had_Lemonade;

      'K' : DO_Killed_Cook;

      'L' : DO_Killed_Uncle;

      'M' : DO_Kissed_Rosie;

      'N' : DO_Used_Gossip;

      'O' : DO_Weapon_Rename;

      { ------------------------------------------------------ }
      { Q - reserved for QUIT/SAVE Changes command processing. }
      { ------------------------------------------------------ }

      'S' : DO_PLAYER_SEARCH;   {06/04/08 rewrite}
        {06/04/08: Changed VIO2EDIT to use S, instead of X code.}

      {01/18/10: Deleted statement for DO_NEWDAY_TESTING.}

      { ------------------------ Added 01/18/10 --------------- }
      'X' : BEGIN               {Created 01/18/10: VERIFIED 01/20/10 3:05 am}
              CWGotoXY(1,21);   {Start on Line 21}

              CWriteLn('                                                                      ');  {09/13/08. needed here}
                {Writes blank line to screen. Line #21. 01/18/10}

              CWriteLn('  `0The `@Delete Player Record `0option is only usable when `$VIO2EDIT ');
              CWriteLn('  `0is executed in `%Debug Mode, `0using the `!/Debug `0parameter. ');
              CWriteLn('  `!This option should only be used with `@EXTREME `!caution!!         ');
                      {01/20/10: rewrote wording of third line}
                      {01/20/10: Line extended to cover up "[Debug Mode]" wording on-screen}

              DELAY(4000);     {wording layout verified}

              IF Debug_Mode THEN   {Created 01/18/10: VERIFIED 01/20/10 3:05 am}
                BEGIN
                  BLANK(1);
                  CWriteLn('  `0Usage of `!/DEBUG `0parameter was detected, so user is allowed ');
                  CWriteLn('  `0to `#Delete this Record.  `0Do this only if absolutely necessary! ');
                  DELAY(3000);

                  DO_PLAYER_DELETION;
                END;

              SHOW_MENU;
            END;
      { ------------------------------------------------------ }

      ']' : BEGIN
              Inc(RecordNum);
              IF RecordNum > (MaxPlayers - 1) THEN RecordNum:= 0;  {02/14/04 edit}

              READ_VISITORS_FILE;
              SHOW_MENU;
            END;

      '[' : BEGIN
              IF RecordNum = 0
                THEN RecordNum:= (MaxPlayers - 1)
                ELSE Dec(RecordNum);

              READ_VISITORS_FILE;
              SHOW_MENU;
            END;

      '*' : BEGIN             {Rewrote 06/04/08: Verified 07/06/08}
              DO_NEW_DAY;

              SHOW_MENU;

              WRITE_VISITORS_FILE;
            END;

    END;       {CASE Code - ending}

  UNTIL Code = 'Q';   {rewrote 06/04/08}
END;       { RUN_EDITOR ---------------------------------------------------------- }


{ 06/04/08: Renamed ExitScreen to EXIT_SCREEN. Did rewrites. }

PROCEDURE EXIT_SCREEN;          {06/04/08: Verified 07/06/08}
BEGIN
  { the | character will cause a linefeed, I forget what max chars }
  { are.  Anyhow, say whatever you want here or remove it totally }

  PromptOK(' Violet''s Cottage II''s P. D. Editor Credits: ',
      'VIO2EDIT.EXE '+Version+'.  Copyright 2007-2011 by Donald Tidmore. ||'
            {12/21/09: updated copyright info for 2010.}

      +'** Dedicated to the memory of Roy Rogers. ** ||'

      +'** Compile Date:  '+Compile_Date+'  Non-Beta development. ||'

      {  +'v1.00 Released officially on:  '+Vers100_Date+' ||'  }

      +'Database Path: '+Editor_Path);       {Compile_Date ends with period.}

END; { EXIT_SCREEN ============================================ }


    { Rewrote 06/04/08 using modified OUTSEDIT code: }
BEGIN    { Main VIO2EDIT.pas BEGIN/END structure }
  ClrScr;

  CursorOff;                  {Gold Tool-Kit process}
  UseLordColors:= TRUE;

  Debug_Mode:= FALSE;   {06/04/08 Code}

  IF S2U(ParamStr(1)) = '/DEBUG'  {06/04/08 Code}
    THEN Debug_Mode:= True;

  ReadVars.ReadHelp:= NIL;
    { removes the HELP button in the prompts. }
    { Gold Tool-Kit process }

  WinNoClose:= TRUE;
      { removes the prompt window close button in upper left. }
      { Gold toolkit process }

  RecordNum:= 0;

  IF Exist('VIO2PLAY.DAX') THEN DeleteFile('VIO2PLAY.DAX');  {06/04/08}

  READ_CONFIG;  {process existing VIO2EDIT.cfg file.}

  Editor_Path:= S2U(IGMDIR+VioPlayer_FN);

  IF Exist(Editor_Path) THEN READ_VISITORS_FILE
  ELSE
    BEGIN
      CWriteLn(' ');
      CWriteLn('  `@ERROR:  `0VIO2EDIT `!could not locate the `@Violet''s Cottage II''s ');
      CWriteLn('  `#VIO2PLAY.DAT `!file, which is `%REQUIRED `!for you to edit ');
      CWriteLn('  `!the IGM''s database records.');

      CWriteLn(' ');
      CWriteLn('  `0VIO2EDIT `!looked for this file, which was not found: ');
      CWriteLn('    `$'+Editor_Path);

      CWriteLn(' ');   {12/18/09}

      CWriteLn('  `#Problem Solving Note: `%Make sure the `!VIO2EDIT.CFG `%file contains ');
                     {12/18/09: verified 12/30/09}
      CWriteLn('  `%the correct path to where the IGM''s data files are located.');      {12/18/09}

      CWriteLn(' ');
      CWriteLn('  `!Terminating `0VIO2EDIT `!after 3 seconds delay.  ');

      DELAY(3000);
      HALT;
    END;
  { =========================================================== }

  RUN_EDITOR;

  EXIT_SCREEN;

  ResetStartUpMode;     {Gold Toolkit process}
END. { VIO2EDIT.pas }


{ Finished first stage coding of VIO2EDIT at 5:49 pm 08/04/05 }
{ 08/04/05: First compilation of VIO2EDIT.EXE at 5:55 pm. }
{ 08/04/05: Fine-tuning change finished at 06:20 pm. }
{ 08/04/05: First stage creation of VIO2UNIT.PAS ended 05:00 pm. }
{ 08/04/05: First successful compilation of VIO2UNIT. 5:54 pm. }
{ Indentation verified, entire file, 03:05 pm 10/12/2005 }

{ Entire file rewritten on 06/04/2008 using already tested }
{ programming code from OUTSEDIT.EXE utility.  Puts into use }
{ the support of /DEBUG parameter. }

      {   Vers100_Date: STRING = 'October 12th, 2005.';  }

  { Created 08/04/05 using JACKEDIT code files. }
  { Rewrote 06/04/08 using code from OUTSEDIT.PAS. }

           { v1.05: 07/27/08: Renamed Father_Fights to Uncle_Fights, }
           { and renamed Killed_Father to Killed_Uncle. }

{07/04/08: used v1.03}
           { 08/11/08. v1.06. Player database format changes. }
           {11/05/08: V1.07 beta}
           {12/07/08: v1.08. 'nope' entry edits}

    { Eliminated usage of VIO2UNIT.PAS unit file on 08/23/2005. }
    { Officially released player editor on October 12th, 2005 as v1.00. }
          {06/04/08: v1.01 beta}

{05/03/09: v1.09 beta}
             {07/04/09: used v1.10 Beta}

