program testcfg;
{a program to install Planets: TEOS IGM's easily by Seth A. Robinson.  Feel
free to use this source to install your own IGM's.}

uses dos,crt,sethlib,plan_var,allpas,bcshare;

const
 igmname = '`!T`9est`!I`9gm';
 igm_filename = 'TESTIGM.EXE';
 config_filename = 'TESTCFG.EXE';
 igm_data = 'TESTIGM.DAT';
var
 teosdir : string;
 install_planet : shortint;

procedure build_world;
{creates w^ index of worlds, ripped out of DDPLUSPI.PAS}
var
msysf: file of plan_rec;
size,rec,ioerror: longint;
begin;
 setfilemode(readdenynone);
 Assign(MSysF,teosdir+'PLANETS.DAT');

 safe_file(0,0,''); repeat; {$I-}
 Reset(MSysF);
 until safe_file(300,ioresult,'RESETTING PLANETS.DAT'); {$I+}

 max_planets := filesize(msysf);
 rec := 1;
 repeat;
  safe_file(0,0,''); repeat; {$I-}
  Seek(MSysF,(Rec-1));
  until safe_file(300,ioresult,'SEEKING PLANETS.DAT'); {$I+}

  safe_file(0,0,''); repeat; {$I-}
  Read(MSysF,p_rec1^);
  until safe_file(300,ioresult,'READING PLANETS.DAT'); {$I+}

        w^.w[rec] := p_rec1^.name;
        w^.owner[rec] := p_rec1^.owner;
        w^.no_warp[rec] := p_rec1^.more[2];
        w^.mode[rec] := p_rec1^.mode;
        w^.deleted[rec] := p_rec1^.more[4];
        inc(rec);

  until eof(msysf);
  {$I-}Close(MSysF);{$I+}
end;

   procedure planet_load( nu: integer);
   {loads a planet record into p_rec, ripped out of DDPLUSPI.PAS
   If you want to copy file routines, use the build_world up above, this
    one was before I made safe_file, it does about the same thing, so I
    didn't update it}
   var
   size,i: integer;
   start: real;
   rec,ioerror,o,e: integer;
   msysf: file of plan_rec;
    h1,h2: string;
    label get_prompt,redraw,load_stuff;
    begin;
    Assign(MSysF,teosdir+'PLANETS.DAT');
   rec := nu;
   load_stuff:
   SetFileMode(Readmode);
   Start:=BCSTimer;
   Repeat;
    {$I-}Reset(MSysF);{$I+}
    IOError:=IOResult;
    If IOError=5 Then Delay(500);
  Until (IOError<>5) Or (TimesUp(Start,10));
  If (IOError<>0) And (IOError<>5) Then
  Begin;
    sethln('Planets.dat not found!  Re unzip PLAN200.ZIP!  This file is in it.');
    sethln('Halting!');
    Halt(0);
  End;
    size := filesize(msysf);
    max_planets := size;
     if nu > size+1 then nu := size+1;
      Seek(MSysF,(nu-1));
        Start:=BCSTimer;
        Repeat;
          {$I-}Read(MSysF,p_rec^);{$I+}
          IOError:=IOResult;
          If IOError=5 Then Delay(500);
        Until (IOError<>5) Or (TimesUp(Start,10));
        If IOError<>0 Then
        Begin;
          sethln('An error occurred reading Planet.dat!');
          sethln('Halting!!!');
          {$I-}Close(MSysF);{$I+}
          If IOResult<>0 Then;
          Halt(0);
         end;
         close(msysf);
      end;



procedure choose_planet;
begin;
seth('`\  `9Which planet `!#`9 my friend? (`!1 to '+lmon(max_planets)+', 0 to abort`9) : `%');

install_planet := edi_num(0,0,2,1,15,install_planet);
install_planet := inside(install_planet,0,max_planets);
sethln('');
end;

function add_igm(pnum: shortint): shortint;
var fil: text;
thefile: string;
count_igm: shortint;
junk: string;
extra,k: byte;
begin;
extra := 0;
planet_load(install_planet);
for k := 1 to 20 do
if p_rec^.shop[k] then inc(extra);
thefile := teosdir+'MAIL\IGM'+lzz(install_planet)+'.DAT';

if exist(thefile) then
  begin;
  assign(fil, thefile);
  reset(fil);
  count_igm := 0;
  repeat;
   inc(count_igm);
   readln(fil,junk);
   if pos(igmname,junk) > 0 then
     begin;
     sethln('`\  `bERROR`%: An IGM with this name is already installed on this planet.`\');
     close(fil);
     key_local;
     add_igm := 2;
     exit;

     end;
  until eof(fil);
  close(fil);
  if count_igm+extra > 7 then
   begin;
   sethln('`\  `4One small problem.  `9You already have eight IGM''s on');
   sethln('  this planet.  You''ll have to pick another.`\');
   key_local;
   add_igm := 1;
   exit;
   end;
  end;


add_text(igmname+'|'+directory+igm_filename+' *',thefile);
{the * is the node #, so the IGM knows what INFO?.file to check}
add_igm := 0;
end;

function get_working_dir : boolean;
begin;
   get_working_dir := TRUE;
   sethln('`\`\  `9Please specify which directory `!PLANETS.DAT`9 is in.');
   seth('  Directory : `%');
   teosdir := up_string(edi(0,0,60,1,15,teosdir));
   if teosdir[length(teosdir)] <> '\' then teosdir := teosdir + '\';
   sethln('`\');
   if exist(teosdir+'PLANETS.DAT') then
    begin;
    sethln('  `%** `!DIR IS GOOD `%**');
    if not ( direxist(teosdir+'MAIL')) then
     begin;
      sethlnr('`\  `2Creating MAIL dir.');
      makedir(teosdir+'MAIL');
      ChDir(DIRECTORY);

     end;
      end else
    begin;
    sethln('  `%** `bCANNOT LOCATE `!PLANETS.DAT `bIN THAT DIR `%**`\');
    sethln('  `%** `bTHIS FILE IS CREATED THE 1ST TIME YOU USE `%**`\');
    sethln('  `%** `bPLANCFG.EXE.                              `%**`\');
    beep;
    key_local;
    get_working_dir := FALSE;
    exit;
    end;

end;

procedure uninstall;
var fil,dest: text;
 thefile: string;
 count_igm,lines: shortint;
 junk,thedest: string;
begin;
 seth('`4Uninstalling this IGM.');
 if not get_working_dir then exit;
 build_world;
 if install_planet = 0 then install_planet := 1;
 sethln('`\  `9Which planet do you want to take this IGM off of?  Hit ENTER for');
 sethln('  the last planet installed on.  (`!'+w^.w[install_planet]+'`9)');
 choose_planet;
 if install_planet = 0 then exit;
 thefile := teosdir+'MAIL\IGM'+lzz(install_planet)+'.DAT';
 thedest := teosdir+'MAIL\IGM'+lzz(install_planet)+'.BAK';
 sethln('');

if not exist(thefile) then
   begin;
    sethln('  `bERROR: `%There are no IGM''s installed on that planet.`\');
    key_local;
   exit;
   end;
 count_igm := 0;
 lines := 0;
 assign(fil, thefile);
 assign(dest, thedest);
 reset(fil);
 rewrite(dest);
 repeat;
 inc(lines);
 readln(fil,junk);
 if pos(igmname,junk) = 0 then writeln(dest,junk) else
 begin;
 sethln('  `%** `9Found a copy and removed it `%**');
 inc(count_igm);
 end;
 until eof(fil);
 close(dest);
 close(fil);

 delete_file(thefile);
 if lines - count_igm <> 0 then
 rename(dest,thefile) else delete_file(thedest);


if count_igm = 0 then
  begin;
  sethln('`\  `bERROR `%: `9Sorry bud, that IGM is not installed on this planet.');
  end;
sethln('');
key_local;
end;


procedure install;
var result: shortint;
fil: text;
label choose_it,insty;
 begin;
     if not get_working_dir then exit;
     build_world;

     insty:
     sethln('`\  `9Install to planet #`%'+lmon(
     install_planet)+'`9?  (`!'+w^.w[install_planet]+'`9)');
     if w^.deleted[install_planet] then
      begin;
      sethln('`\  `bWARNING: `9This planet is currently deleted, no one will be able to use');
      sethln('  the IGM!  You better choose (`!D`9)ifferent planet.');
      end;
     sethln('`\  `9(`!Y`9)es!`\  (`!D`9)ifferent Planet!`\  (`!N`9)evermind');
     seth('`\  `9Your choice.  [`!Y`9] `%: ');
     sread_seth(ch, 'YDN');
     sethln('');
     choose_it:
     if ch = 'N' then exit;
     if ch = 'D' then
      begin;
      choose_planet;
      if install_planet = 0 then exit;
      goto insty;
      end;
     result := add_igm(install_planet);
     if result = 1 then begin; ch := 'D'; goto choose_it; end;
     if result = 2 then exit;
     assign(fil, directory+igm_data);
     rewrite(fil);
     writeln(fil,teosdir);
     writeln(fil, install_planet);
     close(fil);
     sethln('`\  `%WORLD INSTALLED.');
     sethln('`\  `9To try this IGM, play Planets: TEOS and go to planet #`%'+lmon(
     install_planet)+'`9.`\  You should see a new option.`\');
     key_local;
     exit;

 end;

label start;
var
fil: text;
begin;
 new(w);
 new(p_rec1);
 new(p_rec);
 directory := get_dir(config_filename);
 teosdir := directory;
 install_planet := 2; {preferred planet to install upon}
  if exist(directory+igm_data) then
   begin;
     assign(fil, directory+igm_data);
     reset(fil);
     readln(fil,teosdir);
     readln(fil, install_planet);
     close(fil);
  end;

 start:
 sethln('`r0`c`r1'+center(' `%'+igmname+' Installer & Such  ',78)+'`r0`\');
 sethln('  `9(`!I`9)install '+igmname);
 sethln('  `9(`!U`9)ninstall '+igmname);
 sethln('  `9(`!Q`9)uit`\');
 seth('  Yes master? [`!I`9] : `%');
 sread_seth(ch, 'IUQ');

 if ch = 'I' then
  begin;
   install;
   goto start;
  end;

 if ch = 'U' then
  begin;
   uninstall;
   goto start;
  end;

sethln('`\`\  `9Buh-bye.');
sethln('');
cursoron;
end.